/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsErrorIds;
import com.ibm.hwmca.base.settings.network.FirewallAdminException;
import com.ibm.hwmca.base.settings.network.FirewallRule;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.settings.network.config.NetworkApplicationConfig;
import com.ibm.hwmca.base.settings.network.config.NetworkSettingsConfig;
import com.ibm.hwmca.base.settings.network.config.PortConfig;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class FirewallAdmin
implements SettingsErrorIds {
    private HashMap chains = new HashMap();
    private boolean configFilesRestored = false;
    private static final String WEB_PORT = System.getProperty("USING_APACHE_SSL", "false").equals("true") ? "443" : "8080";
    private static final FirewallAdmin instance = new FirewallAdmin();
    private static final String CONFIG_FILENAME = "FirewallSettings.";
    private static final String ALL_IFS_CHAIN_NAME = "ALL-HMC-INPUT";
    private static final String TRACE_MASKD = "XSETFWAD";
    private static final String TRACE_MASKF = "XSETFWAF";
    private static final String TRACE_MASKT = "XSETFWAT";
    private static final FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(85, "FirewallAdmin");

    private FirewallAdmin() {
    }

    public static FirewallAdmin getFirewallAdmin() {
        return instance;
    }

    public void flushFirewallChains() throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.flushFirewallChains");
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            this.flushFirewallChain(chainName);
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.flushFirewallChains");
    }

    public void flushNetAppFirewallChains() throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.flushNetAppFirewallChains");
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            if (!chainName.endsWith("-NETAPP-INPUT")) continue;
            this.flushFirewallChain(chainName);
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.flushNetAppFirewallChains");
    }

    private void flushFirewallChain(String chainName) throws FirewallAdminException {
        block4: {
            try {
                String[] args = new String[]{"flushFirewallChain.sh", chainName};
                int rc = RootProcess.executeProgram(args);
                if (rc == 0 || rc == 1) {
                    ArrayList rules = (ArrayList)this.chains.get(chainName);
                    if (rules != null) {
                        rules.clear();
                    }
                    break block4;
                }
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            catch (IOException e) {
                FirewallAdminException exc = new FirewallAdminException(e);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
    }

    public void addFirewallRule(FirewallRule rule) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.addFirewallRule: rule=" + rule);
        String ifName = rule.getInterfaceName();
        String chainName = null;
        chainName = rule instanceof NetAppFirewallRule ? ifName + "-NETAPP-INPUT" : ifName + "-HMC-INPUT";
        ArrayList<FirewallRule> rules = (ArrayList<FirewallRule>)this.chains.get(chainName);
        if (rules == null) {
            this.createFirewallChain(chainName, ifName);
            rules = new ArrayList<FirewallRule>();
            this.chains.put(chainName, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--append", chainName, rule.getInterfaceName(), rule.getProtocol(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getPort()};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc == 0) {
                if (rule instanceof NetAppFirewallRule) {
                    String appId = ((NetAppFirewallRule)rule).getAppId();
                    if (!appId.equals("-")) {
                        rules.add(rule);
                    }
                } else {
                    rules.add(rule);
                }
            } else {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            if (!rule.getAdditionalPorts().isEmpty()) {
                Trace.trace(TRACE_MASKF, "adding rules for additional ports");
                Iterator it = rule.getAdditionalPorts().iterator();
                while (it.hasNext()) {
                    String portString = (String)it.next();
                    String[] protocolPort = portString.split(":", 2);
                    args[4] = protocolPort[0];
                    args[7] = protocolPort[1];
                    rc = RootProcess.executeProgram(args);
                    if (rc == 0) continue;
                    FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                    new FrameworkLog(logInfo, 2396, exc).log();
                    throw exc;
                }
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.addFirewallRule");
    }

    public void removeFirewallRule(FirewallRule rule) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.removeFirewallRule: rule=" + rule);
        String ifName = rule.getInterfaceName();
        String chainName = null;
        chainName = rule instanceof NetAppFirewallRule ? ifName + "-NETAPP-INPUT" : ifName + "-HMC-INPUT";
        ArrayList rules = (ArrayList)this.chains.get(chainName);
        if (rules == null) {
            this.createFirewallChain(chainName, ifName);
            rules = new ArrayList();
            this.chains.put(chainName, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--delete", chainName, rule.getInterfaceName(), rule.getProtocol(), rule.getSourceAddr(), rule.getSourceAddrMask(), rule.getPort()};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc == 0) {
                if (!rules.remove(rule)) {
                    Trace.trace(TRACE_MASKF, "FirewallAdmin.removeFirewallRule: didn't find rule in list");
                }
            } else {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                throw exc;
            }
            if (!rule.getAdditionalPorts().isEmpty()) {
                Iterator it = rule.getAdditionalPorts().iterator();
                while (it.hasNext()) {
                    String portString = (String)it.next();
                    String[] protocolPort = portString.split(":", 2);
                    args[4] = protocolPort[0];
                    args[7] = protocolPort[1];
                    rc = RootProcess.executeProgram(args);
                    if (rc == 0) continue;
                    FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                    throw exc;
                }
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.removeFirewallRule");
    }

    public void addRuleForAllInterfaces(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.addRuleForAllInterfaces");
        ArrayList rules = (ArrayList)this.chains.get(ALL_IFS_CHAIN_NAME);
        if (rules == null) {
            this.createFirewallChain(ALL_IFS_CHAIN_NAME, "");
            rules = new ArrayList();
            this.chains.put(ALL_IFS_CHAIN_NAME, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--insert", ALL_IFS_CHAIN_NAME, "", protocol, sourceAddr, sourceAddrMask, port};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
            Trace.trace(TRACE_MASKF, "added rule successfuly");
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.addRuleForAllInterfaces");
    }

    public void removeRuleForAllInterfaces(String sourceAddr, String sourceAddrMask, String protocol, String port) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.removeRuleForAllInterfaces");
        ArrayList rules = (ArrayList)this.chains.get(ALL_IFS_CHAIN_NAME);
        if (rules == null) {
            this.createFirewallChain(ALL_IFS_CHAIN_NAME, "");
            rules = new ArrayList();
            this.chains.put(ALL_IFS_CHAIN_NAME, rules);
        }
        String[] args = new String[]{"editFirewallChain.sh", "--delete", ALL_IFS_CHAIN_NAME, "", protocol, sourceAddr, sourceAddrMask, port};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                throw exc;
            }
            Trace.trace(TRACE_MASKF, "deleted rule successfuly");
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.removeRuleForAllInterfaces");
    }

    public List getFirewallRules(String ifName) {
        String chainName = ifName + "-HMC-INPUT";
        ArrayList rules = (ArrayList)this.chains.get(chainName);
        if (rules == null) {
            rules = new ArrayList();
            this.chains.put(chainName, rules);
        }
        return new ArrayList(rules);
    }

    public List getNetAppFirewallRules(String ifName) {
        String chainName = ifName + "-NETAPP-INPUT";
        ArrayList rules = (ArrayList)this.chains.get(chainName);
        if (rules == null) {
            rules = new ArrayList();
            this.chains.put(chainName, rules);
        }
        return new ArrayList(rules);
    }

    private void createFirewallChain(String name, String ifName) throws FirewallAdminException {
        String[] args = new String[]{"createFirewallChain.sh", name, ifName};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0 && rc != 1) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
    }

    private void writeConfigFile(String chainName, ArrayList rules) throws IOException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.writeConfigFile");
        String filename = null;
        try {
            filename = BaseFileControl.getFilePath(CONFIG_FILENAME) + CONFIG_FILENAME + chainName;
        }
        catch (HException e) {
            IOException exc = new IOException("Unable to find location of config file");
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileOutputStream(filename));
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                NetAppFirewallRule rule = (NetAppFirewallRule)it.next();
                out.print(rule.getAppId());
                out.print("|");
                out.print(rule.getSourceAddr());
                out.print("|");
                out.print(rule.getSourceAddrMask());
                out.print("\n");
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.writeConfigFile");
    }

    public void writeConfigFiles() throws IOException {
        if (!this.configFilesRestored) {
            Iterator it = this.chains.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String chainName = (String)entry.getKey();
                ArrayList rules = (ArrayList)entry.getValue();
                if (!chainName.endsWith("-NETAPP-INPUT")) continue;
                this.writeConfigFile(chainName, rules);
            }
        } else {
            Trace.trace(TRACE_MASKF, "FirewallAdmin.writeConfigFiles: config files have been restored.. not going to overwrite the values");
        }
    }

    public List getConfigFilenames() {
        ArrayList<String> filenames = new ArrayList<String>();
        Iterator it = this.chains.keySet().iterator();
        while (it.hasNext()) {
            String chainName = (String)it.next();
            if (!chainName.endsWith("-NETAPP-INPUT")) continue;
            filenames.add(CONFIG_FILENAME + chainName);
        }
        return filenames;
    }

    public void readConfigFile(String ifName, boolean apply) throws IOException, FirewallAdminException {
        ArrayList<NetAppFirewallRule> rules;
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.readConfigFile(" + ifName + "," + apply + ")");
        String chainName = ifName + "-NETAPP-INPUT";
        String filename = null;
        try {
            String filePath = BaseFileControl.getFilePath(CONFIG_FILENAME);
            filename = filePath + CONFIG_FILENAME + chainName;
        }
        catch (HException e) {
            IOException exc = new IOException("Unable to find location of config file");
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
        if (apply) {
            this.createFirewallChain(chainName, ifName);
            this.flushFirewallChain(chainName);
        }
        if ((rules = (ArrayList<NetAppFirewallRule>)this.chains.get(chainName)) == null) {
            rules = new ArrayList<NetAppFirewallRule>();
            this.chains.put(chainName, rules);
        }
        rules.clear();
        BufferedReader in = null;
        File file = new File(filename);
        if (file.exists() && file.canRead()) {
            String line;
            Trace.trace(TRACE_MASKD, "FirewallAdmin.readConfigFile: found saved config file");
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                Trace.trace(TRACE_MASKF, "FirewallAdmin: processing line='" + line + "'");
                NetAppFirewallRule rule = null;
                StringTokenizer st = new StringTokenizer(line, "|");
                int nTokens = st.countTokens();
                if (nTokens < 3) {
                    Trace.trace(TRACE_MASKF, "Invalid number of tokens in config file: " + nTokens);
                } else {
                    String appId = st.nextToken();
                    String sourceAddr = st.nextToken();
                    String sourceAddrMask = st.nextToken();
                    List ports = this.getPortsForNetApp(appId);
                    if (ports.size() > 0) {
                        String[] port = (String[])ports.get(0);
                        rule = new NetAppFirewallRule(appId, ifName, sourceAddr, sourceAddrMask, port[0], port[1]);
                        for (int i = 1; i < ports.size(); ++i) {
                            port = (String[])ports.get(i);
                            rule.addAdditionalPort(port[0], port[1]);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "Invalid ports returned by getPortsForNetApp");
                    }
                }
                if (rule == null) continue;
                if (apply) {
                    this.addFirewallRule(rule);
                    continue;
                }
                rules.add(rule);
            }
            in.close();
        } else {
            Trace.trace(TRACE_MASKF, "FirewallAdmin: Unable to read saved config file.. loading defaults");
            this.loadDefaultConfig(ifName, rules, apply);
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAdmin.readConfigFile");
    }

    private void loadDefaultConfig(String ifName, List rules, boolean apply) throws FirewallAdminException {
        Trace.trace(TRACE_MASKT, "-> FirewallAdmin.loadDefaultConfig()");
        Iterator it = NetworkSettingsConfig.getNetworkSettingsConfig().getNetApps().iterator();
        while (it.hasNext()) {
            NetworkApplicationConfig netApp = (NetworkApplicationConfig)it.next();
            Trace.trace(TRACE_MASKF, "Checking defaults for " + netApp.getApplicationID());
            if (!netApp.isPublicDefaultAllow() && !netApp.isPrivateDefaultAllow()) continue;
            Trace.trace(TRACE_MASKF, "Default for " + netApp.getApplicationID() + " is allow");
            PortConfig[] ports = netApp.getPortsArray();
            if (ports.length > 0) {
                String protocol = null;
                switch (ports[0].getType()) {
                    case 1: {
                        protocol = "tcp";
                        break;
                    }
                    case 2: {
                        protocol = "udp";
                        break;
                    }
                    case 3: {
                        protocol = "icmp";
                    }
                }
                NetAppFirewallRule rule = new NetAppFirewallRule(netApp.getApplicationID(), ifName, "0.0.0.0", "0.0.0.0", protocol, ports[0].getNumber());
                for (int i = 1; i < ports.length; ++i) {
                    switch (ports[i].getType()) {
                        case 1: {
                            protocol = "tcp";
                            break;
                        }
                        case 2: {
                            protocol = "udp";
                            break;
                        }
                        case 3: {
                            protocol = "icmp";
                        }
                    }
                    Trace.trace(TRACE_MASKF, "adding port " + protocol + ":" + ports[i].getNumber());
                    rule.addAdditionalPort(protocol, ports[i].getNumber());
                }
                if (apply) {
                    this.addFirewallRule(rule);
                    continue;
                }
                rules.add(rule);
                continue;
            }
            Trace.trace(TRACE_MASKF, "netApp didn't have any ports");
        }
        Trace.trace(TRACE_MASKF, "<- FirewallAdmin.loadDefaultConfig()");
    }

    private List getPortsForNetApp(String appId) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        NetworkSettingsConfig netAppConfig = NetworkSettingsConfig.getNetworkSettingsConfig();
        NetworkApplicationConfig netApp = netAppConfig.getNetApp(appId);
        if (netApp != null) {
            PortConfig[] ports = netApp.getPortsArray();
            for (int i = 0; i < ports.length; ++i) {
                String protocol = null;
                switch (ports[i].getType()) {
                    case 1: {
                        protocol = "tcp";
                        break;
                    }
                    case 2: {
                        protocol = "udp";
                        break;
                    }
                    case 3: {
                        protocol = "icmp";
                    }
                }
                list.add(new String[]{protocol, ports[i].getNumber()});
            }
        } else {
            Trace.trace(TRACE_MASKF, "NetworkSettingsConfig.getNetApp returned null");
        }
        return list;
    }

    public void restoreBootConfig() throws FirewallAdminException {
        String[] args = new String[]{"restoreFirewallConfig.sh"};
        try {
            int rc = RootProcess.executeProgram(args);
            if (rc != 0 && rc != 1) {
                FirewallAdminException exc = new FirewallAdminException("Process returned code: " + rc);
                new FrameworkLog(logInfo, 2396, exc).log();
                throw exc;
            }
        }
        catch (IOException e) {
            FirewallAdminException exc = new FirewallAdminException(e);
            new FrameworkLog(logInfo, 2396, exc).log();
            throw exc;
        }
    }

    public void setConfigFilesRestored(boolean configFilesRestored) {
        Trace.trace(TRACE_MASKF, "<> FirewallAdmin.setConfigFilesRestored: " + configFilesRestored);
        this.configFilesRestored = configFilesRestored;
    }

    public void enableWebPorts() throws FirewallAdminException {
        this.addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", WEB_PORT);
        this.addRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", String.valueOf(9960));
    }

    public void disableWebPorts() throws FirewallAdminException {
        this.removeRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", WEB_PORT);
        this.removeRuleForAllInterfaces("0.0.0.0", "0.0.0.0", "tcp", String.valueOf(9960));
    }

    public static void main(String[] args) throws Exception {
    }
}

